// Copyright 1998, 1999, 2000, 2001, 2002, 2003 Macromedia, Inc. All rights reserved.

//*************** GLOBALS VARS *****************

var helpDoc = MM.HELP_behPreloadImages;

//******************* BEHAVIOR FUNCTION **********************

//get from external file MM_preloadImages.js

//******************* API **********************


//Always okay to use.

function canAcceptBehavior(){
  return true;
}



//Returns a Javascript function to be inserted in HTML head with script tags.

function behaviorFunction(){
  return "MM_preloadImages";
}



//Returns fn call to insert in HTML tag <TAG... onEvent='thisFn(arg)'>
//Gets list of img filenames from the select list. Strips spaces off each name,
//URL encodes them, wraps them in quotes, and returns them as a list of args.

function applyBehavior(uniqueName) {
  var i,argList="",imgFileStr, imgFileArray;

  imgFileArray = document.imgList.get('all');
  for (i=0;i<imgFileArray.length;i++) {  //step thru menu
    imgFileStr = listControlStripSpaces(imgFileArray[i]);  //strip leading and following spaces
    if (imgFileStr) {  //if any string exists
      if (argList) argList += ",";  //if not the first one, add a comma
      argList += "'"+dw.doURLEncoding(imgFileStr)+"'";  //concatenate string in quotes
    }
  }
  if (document.preloadID) argList += ",'"+document.preloadID+"'";  //concatenate id in quotes

  if (argList) {
    updateBehaviorFns("MM_preloadImages");
    return "MM_preloadImages("+argList+")";  //return fn call with args
  }
  else         return MSG_NoImgNames;
}



//Returns a dummy function call to inform Dreamweaver the type of certain behavior
//call arguments. This information is used by DW to fixup behavior args when the
//document is moved or changed.
//
//It is passed an actual function call string generated by applyBehavior(), which
//may have a variable list of arguments, and this should return a matching mask.
//
//The return values are:
//  URL     : argument could be a file path, which DW will update during Save As...
//  NS4.0ref: arg is an object ref that may be changed by Convert Tables to Layers
//  IE4.0ref: arg is an object ref that may be changed by Convert Tables to Layers
//  other...: argument is ignored

function identifyBehaviorArguments(fnCallStr) {
  var argList, argArray, i;

  argList = "";
  argArray = extractArgs(fnCallStr);
  for (i=1; i<argArray.length; i++) { //with each img URL
	if (argArray[i].charAt(0)=="#")
      argList += ((argList)?",":"")+"other";
	else argList += ((argList)?",":"")+"DEP";
  }
  return argList;
}



//Given the original function call, this parses out the args and updates
//the UI. With each image filename, URL decodes it, and adds it to the list.
//Loads the first item for editing.

function inspectBehavior(behFnCallStr){
  var argArray,imgFileStr,i;

  argArray = extractArgs(behFnCallStr);//gets list of args (first is fn name, ignore)
  if (argArray.length > 1) {
    for (i=1; i<argArray.length; i++){ //with each img
      imgFileStr = unescape(argArray[i]); //undo URL encoding
      if (imgFileStr.charAt(0) != "#") //don't display special id code
        document.imgList.append(imgFileStr); //add item
      else document.preloadID = imgFileStr; //save ID
    }
    document.imgList.append(); //add new, blank item
  }
}



//***************** LOCAL FUNCTIONS  ******************


//Clears the select menu "itemList" and selects the first item

function initializeUI(){
  document.preloadID = "";
  document.imgList = new listControl(document.theForm.itemList, document.theForm.itemEntry);
  document.imgList.append(); //add new, blank item
}



//Invokes dialog to allow user to select filename. Puts value in text input.

function browseFileAndSet(){
  var fileName,imgSrcList="";
  fileName = browseForFileURL("select", "", true);  //returns a local filename
  if (fileName) {
    document.theForm.itemEntry.value = fileName;
    document.imgList.set(fileName);
  }
}



//***************** LIST CLASS FUNCTIONS  ******************

//classListControl.js
//
//This control consists of a SELECT control and an optional INPUT/TEXT.
//If you provide an INPUT/TEXT, it will always keep it in sync w/ the selection.
//
//To define a new listControl, create a global variable and define it after onLoad:
//  MYLIST = new listControl(document.theForm.theSelect);
//
//If you have a matching INPUT/TEXT, provide it as the 2nd argument:
//  MYLIST = new listControl(document.theForm.theSelect, document.theForm.theText);
//
//Thereafter, you can call methods and get properties, for example:
//  MYLIST.append('default');    MYLIST.get();   length = MYLIST.len;
//
//See properties and methods below:

function listControl(listObj,inputTextObj) {
  // PROPERTIES
  this.object     = listObj;           //SELECT object
  this.input      = inputTextObj;      //INPUT/TEXT object (optional)
  this.len        = 0;                 //current length of the list
  this.index      = 0;                 //current selectedIndex

  // METHODS
  this.append     = listControlAppend; // append()    //append a new blank line to end of list
                                       // append('default')      //append default text
                                       // append('default',true) //append default text and enumerate
  this.del        = listControlDel;    // del()       //delete selected line
  this.set        = listControlSet;    // set('text') //set current line to text
  this.refresh    = listControlRefresh;// refresh()   //refresh text input (for SELECT's onChange)
  this.get        = listControlGet;    // get()       //return current selection text
                                       // get(n)      //return text item n (starts at zero)
                                       // get('all')  //return array of all text items
}



//Append a new, blank item to the end of the list.
//If there is no selection, it replaces the first item.

function listControlAppend(defaultItem){
  var i, retVal = false;
  with (this.object) {
    this.index = this.len; //should be after last line
    while (this.index > 0 && (options[this.index-1].text == "")) this.index--; //find earliest blank line
    if (!defaultItem) defaultItem = "";  //if no defaultItem, make it blank
    options[this.index] = new Option(listControlStripSpaces(defaultItem));  //append new item
    selectedIndex = this.index;  //select new item
    this.len = options.length;
    while (this.len > 0 && (options[this.len-1].text == "")) this.len--; //find earliest blank line
    retVal = true;
  }
  if (this.input) with (this.input) {  //if there's a text input, update it
    value = this.get();
    focus();
    select();
  }
  return retVal;
}



//Deletes the currently selected item, and selects the one that followed it.

function listControlDel() {
  var i, retVal = false;
  with (this.object) {
    this.index = selectedIndex; //get insertion point
    if (this.index >= 0) {  //if there is a selection
      lastIndex = this.len - 1;
      for (i=this.index; i<lastIndex; i++)
        options[i] = new Option(options[i+1].text); //shift items after deleted line
      options[i].text = "";  //clear out extra line at end
      selectedIndex = (this.index < lastIndex)? this.index : --this.index; //if deleted last item, move selection up one
      this.len = options.length;
      while (this.len > 0 && (options[this.len-1].text == "")) this.len--; //find last non-blank line
      retVal = true;
    }
  }
  if (this.input) with (this.input) {  //if there's a text input, update it
    value = this.get();
    focus();
    select();
  }
  return retVal;
}



//Replaces the list selection with the value of the text entry.

function listControlSet(itemStr) {
  var retVal = false;
  with (this.object) {
    this.index = selectedIndex;
    if (this.index > -1 && itemStr) {  // if something selected & non-empty
      if (options[this.index].text != itemStr) {  //if text has been changed
        if (this.index > this.len) this.index = this.len; //don't exceed list len
        options[this.index].text = listControlStripSpaces(itemStr);  //replace text
        selectedIndex = this.index; //reselect
        this.len = options.length;  //recompute length by counting backward thru blank lines
        while (this.len > 0 && (options[this.len-1].text == "")) this.len--; //find last non-blank line
      }
      retVal = true;
  } }
  return retVal;
}



//Called when there's a new selection, loads and selects the text entry.

function listControlGet(index) {
  var i, retVal = "";  //return blank if all else fails
  with (this.object) {
    if (!index) index = selectedIndex;  //if they don't pass a num, use index
    if (index == "all") {
      var retVal = new Array();
      for (i=0; i<this.len; i++) retVal[i] = options[i].text;  //if 'all', return array
    } else if (index > -1) {
      retVal = options[index].text;
  } }
  return retVal;
}



//Called when there's a new selection, loads and selects the text entry.

function listControlRefresh() {
  var retVal = false;
  with (this.object) {
    this.index = selectedIndex;
    if (this.index > -1) {  //if something selected
      if (this.input) with (this.input) {  //if there's a text input, update it
        value = this.get();
        focus();
        select();
      }
      retVal = true;
  } }
  return retVal;
}



//Given a string, strips all leading and ending spaces and returns the result.

function listControlStripSpaces(theStr) {
  if (!theStr) theStr = "";  //ensure its not null
  var firstNonSpace = 0;
  var lastNonSpace = theStr.length - 1;
  while (theStr.charAt(firstNonSpace) == " " && firstNonSpace < theStr.length) firstNonSpace++;
  while (theStr.charAt(lastNonSpace) == " " && lastNonSpace > 0) lastNonSpace--;
  return theStr.substring(firstNonSpace, lastNonSpace+1);
}
